PORT     = arg[1] or 'COM1'
FIRMWARE = arg[2] or 'ssr1_v2_2_5.bin'

 
if not jf.CaptureTarget(PORT) then
  print('Unable to open serial port.')
  return
end

i=jf.ReadImage('flashloader.img')
jf.RAMExec(i, false)                  -- do not hang up after executing image

print('Blank Checking Flash Sector 2.')
if not jf.BlankCheck(2) then
  print('Erasing Flash Sector 2.')
  if not jf.EraseFlash(2) then
    print('Error erasing sector 2')
    return
  end
end

print('Reading MCU code image.')
i=jf.ReadImage(FIRMWARE)
if not i then
  print('Error reading MCU code flash image.')
  return
end
jf.ProgramFlash(i)

